﻿using Spectral1.DATA_ACCESS;
using Spectral1_VBClassLibrary;
using System;
using System.Data;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using static Spectral1_VBClassLibrary.DataSet_Spectral_System;

namespace Spectral1.BUSINESS_LOGIC
{
    public class BL_Patch
    {
        #region "================ DECLARATIONS ========================"
        static CodeGen_DS_Spectral _CGS;
        static DA_Spectral _DASP;
        private c_patch _current_patch;
        private PL_Main _plm;

        #endregion

        #region "================ PROPERTIES ========================"
        public c_patch current_patch
        {
            get
            {
                if (_CGS.Table_patch.CurrentRow.RowIsEmpty == true)
                { return null; }
                else
                {
                    if ((_current_patch == null) ||(_CGS.Table_patch.CurrentRow.patch_id != _current_patch.patch_id))
                    {
                        set_current_patch(_CGS.Table_patch.CurrentRow.patch_id);
                    }
                }

                return _current_patch;
            }
        }
        #endregion

        #region "================ METHODS ========================"
        public BL_Patch(CodeGen_DS_Spectral CGS, DA_Spectral DASP,PL_Main plm)
        {
            _CGS = CGS;
            _DASP = DASP;
            _plm = plm;
        }

        public int add_new_patch_with_related_data(string new_description)
        {
            bool initial_flag_suppress_patch_events = _plm.BL.DA.DASystem.flag_suppress_patch_events;
            _plm.BL.DA.DASystem.flag_suppress_patch_events = true;
            int new_patch_id = _plm.BL.DA.CGS.Table_patch.AddRow();
            _plm.BL.BLPatch.set_current_patch(new_patch_id);
            current_patch.patch_guid8 = BL_Spectral.GetNewGuid8();
            if (new_description != "") { current_patch.description = new_description; }
            _plm.BL.BLPatch.current_patch.InitialisePatchRelatedTables(new_patch_id, -1);
            _plm.BL.DA.DASystem.flag_suppress_patch_events = initial_flag_suppress_patch_events;

            return new_patch_id;
        }

        public void set_current_patch(Int32 patch_id)
        {
            _current_patch = new c_patch(_CGS, _DASP, patch_id);
            //TO DO: Set any filters here
        }

        public void set_patch_waveset_and_filter(int waveform_set_id, int body_resonance_filter_id)
        {
            current_patch.waveform_set_id = waveform_set_id;
            current_patch.body_resonance_filter_id = body_resonance_filter_id;
        }

        public void load_preset(Int32 adsr_preset_id, float bulk_value)
        {
       
        }


        public void set_sample(Int32 patch_id, adsr_sections section_id, bool set_on, inharmonic_sample_playback_modes playback_mode)
        {
            for (adsr_sections i = 0; i <= adsr_sections.adsr_section_release; i++)
            {
                _plm.BL.DA.CGS.Table_adsr_section.GetRow(patch_id, Convert.ToInt32(i)).inharmonic_sample_id = 0;
            }

            if (set_on == true)
            {
                _plm.BL.DA.CGS.Table_adsr_section.GetRow(patch_id, Convert.ToInt32(section_id)).inharmonic_sample_id = 1;
                _plm.BL.DA.CGS.Table_adsr_section.GetRow(patch_id, Convert.ToInt32(section_id)).inharmonic_sample_playback_mode_id = Convert.ToInt32(playback_mode);
            }
        }

        public string check_lfo_timbre_config()
        {
            if (current_patch == null) { return ""; }

            string error_text = "";
            lfo_envelope_configRow ecr = _plm.BL.DA.CGS.Table_lfo_envelope_config.GetRow(current_patch.patch_id, Convert.ToInt32(lfos.lfo_timbre));

            if (ecr.enabled == 1)
            {
                for (int r = 0; r <= (Int32)adsr_sections.adsr_section_release; r++)
                {
                    adsr_section_envelope_configRow secr = _plm.BL.DA.CGS.Table_adsr_section_envelope_config.GetRow(current_patch.patch_id, (Int32)adsr_sections.adsr_section_attack, (Int32)envelope.env_timbre_lfo);
                    if (secr.depth_env_type_id == (Int32)env_types.env_type_none)
                    {
                        error_text += "Error: When the Timbre LFO is set, the Timbre LFO depth envelope must be active for all adsr sections. Even if the envelope is static." + Environment.NewLine + Environment.NewLine;
                        break;
                    }
                }

                for (int r = 0; r <= (Int32)adsr_sections.adsr_section_release; r++)
                {
                    adsr_section_envelope_configRow secr = _plm.BL.DA.CGS.Table_adsr_section_envelope_config.GetRow(current_patch.patch_id, (Int32)adsr_sections.adsr_section_attack, (Int32)envelope.env_timbre);
                    if (secr.depth_env_type_id == (Int32)env_types.env_type_none)
                    {
                        error_text += "Error: When the Timbre LFO is set, the Timbre Morph envelope must be active AND CHANGING for all adsr sections, to ensure that the timbre is regularly updated (it updates on change). Any non-zero change will work." + Environment.NewLine + Environment.NewLine;
                        break;
                    }
                }
            }

            return error_text;
        }
        #endregion

    }
}
